//==================================================================================
//=== TSR_Mirror === A Plugin by The Northern Frog =================================
//==================================================================================

var TSR = TSR || {};
TSR.mirror = TSR.mirror || {};
TSR.mirror.version = 1.25;

var Imported = Imported || {};
Imported.TSR_Mirror = true;

//==================================================================================

/*:
 * @target MZ
 * @plugindesc v1.2.5 Use map region Id or terrain tag to create floor or wall mirrors 
 *             that will reflect player, followers and events.
 * @author TSR, The Northern Frog, 2021      
 * @help 
 * =================================================================================
 * == About this Plugin ============================================================
 * =================================================================================
 * Use either map region Id or terrain tag to defines tiles as mirrors. These 
 * tiles will display the reflection of player, followers and events.
 * 
 * The reflection sprites are created bellow the tileset level, but above 
 * parallax level. That means the tiles you define as mirror should have 
 * a slightly decreased opacity so the reflection sprites can be seen
 * beneath. You can then add a parallax as a background for the mirrors.
 * 
 * The plugin provide 2 types of mirror tiles:
 * 
 *      Wall Mirrors:
 *         The reflection sprites are exact copy of the characters they 
 *         represent, and mirror their movements. When approaching the
 *         mirror, reflection first appear at top of the mirror, and as
 *         the character get nearer, it will move down to be just in front
 *         of the character when it is standing in front of the mirror.
 *
 *              Parameters
 *        ==========================================================
 *       X Offset = the horizontal offset of the reflection sprite.
 * 
 *       Y Offset = the vertical offset of the reflection sprite.
 * 
 * 
 * 
 *      Floor Mirrors:
 *         The reflection sprite can have a little blur filter and a 
 *         small angulation. They always stick slightly to a fixed 
 *         position relatives to the character they represent. The
 *         floor mirrors settings are managed by plugin parameters.
 * 
 *              Parameters
 *        ==========================================================
 *       X Offset = the horizontal offset of the reflection sprite,
 *                  relative to the character. 
 * 
 *       Y Offset = the vertical offset of the reflection sprite,
 *                  relative to the character.
 * 
 *          Angle = the angle of the reflection sprite rotation. Set it
 *                  to 0 for no rotation or 2 to flip the sprite upside
 *                  down. Float values can be used.
 * 
 *           Blur = the strenght of the blur effect on the reflection
 *                  sprite. Set it to 0 for no blur.
 * 
 *       Opactity = the opacity of the reflection sprite ranging from
 *                  0 (invisible) to 255 (full opacity).
 * 
 *          Pulse = enable a slight pulsating effect on the reflection
 *                  sprite to mimic water movement.
 * 
 * 
 * 
 *  HOW TO USE:
 * 
 *         1) Select the tiles on your tileset that you want to act
 *            as mirror. Make the part of the tile where reflection 
 *            should appear semi-transparent (50-75% opacity).
 *  
 *         2) Set the Plugin parameters and choose map region Id or
 *            terrain tag to mark the mirror tiles.
 * 
 *         3) Place the mirror tiles on you map and mark them with the
 *            id you selected in the parameters. Make sure there's no
 *            other layers bellow the mirror tiles, because the reflection
 *            sprites appears beneath all tiles layer.
 * 
 * 
 * 
 *  EVENT COMMENT TAG:
 *          Use the following Event Comment Tag to prevent reflection of
 *          an event page.
 * 
 *                               <NO MIRROR>
 * 
 * 
 *          Those comment tags can be used to assign specific offset to
 *          an event reflection on wall or floor.
 * 
 *                         <WALL MIRROR OFFSET: X, Y>
 * 
 *                        <FLOOR MIRROR OFFSET: X, Y>
 * 
 * 
 *          This Event Comment Tag will prevent the flipping of the vertical
 *          direction of the reflections. This is useful when using a non
 *          character sheet such as 'Flame', 'Switch' or 'Doors'.
 * 
 *                             <FIX MIRROR IMAGE>
 * 
 * 
 * 
 *  MAP NOTE TAG:
 *          Use this notetag in a map notebox to turn map region Id into
 *          floor mirror. These floor mirrors will use the setting defined
 *          by the notetag instead of those set in the parameters. You
 *          can put more than one notetag in a map notebox to add more 
 *          floor mirror region Id with different settings.
 * 
 *       <FLOOR MIRROR INFO: regionId, x, y, angle, blur, opacity, pulse>
 * 
 *       regionId = the map region Id that is turned into a floor mirror
 *                  with the settings defined by the following arguments. 
 *              x = the horizontal offset of the reflection sprite,
 *                  relative to the character. 
 *              y = the vertical offset of the reflection sprite,
 *                  relative to the character. 
 *          angle = the angle of the reflection sprite rotation. Set it
 *                  to 0 for no rotation or 2 to flip the sprite upside
 *                  down. Float values can be used.
 *           blur = the strenght of the blur effect on the reflection
 *                  sprite. Set it to 0 for no blur.
 *       opactity = the opacity of the reflection sprite ranging from
 *                  0 (invisible) to 255 (full opacity).
 *          pulse = enable a slight pulsating effect on the reflection
 *                  sprite to mimic water movement.
 *
 * 
 *          MIRROR BACKGROUND
 *          =================
 *          Use the following map notetag to draw an image from the /img/
 *          parallaxes folder of your game, and use it as background for
 *          your mirroring areas. You can use images of any size and set
 *          as many mirror background as you need.
 * 
 *              <**LABEL** MIRROR BACKGROUND: filename, x, y, z> 
 * 
 *      **LABEL** = the label or name of the notatag. You can name it as
 *                  you want, but be sure that it is followed by the key
 *                  words 'mirror background'. If you use more than one
 *                  notetag, each must have a different name, of course.
 *              x = the map tile X of the left border of your background
 *                  image. You can use float number.
 *              y = the map tile Y of the top border of your background
 *                  image. You can use float numbers.
 *              z = the z index of your background image. You can use
 *                  float numbers.
 * 
 *                **Wall reflection sprites have a z index of -0.5 and 
 *                  floor reflection sprites have a z index between -0.6
 *                  and -0.8. Use z values bellow the reflection sprites
 *                  for your background images.
 *     
 * 
 *  CHANGING REFLECTION SPRITE:
 *          If for whatever reason you want to change a character 
 *          reflection sprite to another character sprite, you can 
 *          use the following scriptcall:
 * 
 *          character.setReflectionChar([character sheet, character index]);
 * 
 *              *replace character by either:
 *                  $gamePlayer  //for the player
 *                  $gamePlayer.followers().follower(index) //for a follower
 *                  $gameMap.event(evenId)  //for a map event
 *  
 *          Example:
 *              $gamePlayer.setReflectionChar(['Actors1', 3]);
 * 
 *              This call will change the player reflection sprite to
 *              the character at index 3 on character sheet 'Actors1'
 *              
 *                  *note that the arguments are inside an array so
 *                   don't forget the square brackets. The name of
 *                   the character sheet must be inside quotes.
*          
 *          To revert back to the original sprite, set the method to false:
 * 
 *               $gamePlayer.setReflectionChar(false);
 *          
 *          This will set the player reflection sprite back to the original
 *          setting in the database.       
 *  
 * 
 * 
 * =======================================================================================
 * == Term of Usage ======================================================================
 * =======================================================================================
 * 
 * Use in any independant RPG Maker MZ or MV projects, including commercials.
 *
 * Credit is required for using this Plugin. 
 * For crediting, use 'TSR' along with one of
 * the following terms: 
 *      'The Northern Frog' or 'A frog from the north'
 * 
 * Do not change the Header or the Terms of usage.
 *
 * DO NOT REDISTRIBUTE!
 * If you want to share it, share the link to my itch.io account: 
 * https://the-northern-frog.itch.io/
 * 
 *
 * =======================================================================================
 * == Version and compatibility ==========================================================
 * =======================================================================================
 * 2021/02/15 completed plugin, v1.0.0
 * 2021/02/18 small fix on wall mirror functions, v1.0.1
 * 2021/02/20 fix wall and floor mirror reflection position delay, v1.0.2
 * 2021/02/21 fix bug due to previous update, v1.0.3
 * 2021/02/21 add parameters for floor mirrors settings, v1.0.4
 * 2021/03/14 add the regionId argument to the map notetag, v1.0.5
 * 2021/03/17 fix reflection for event with image from tile sheet, v1.0.6
 * 2021/03/18 fix compatibility with TSR_MoveEvent, v1.0.7
 * 2021/03/19 add wall and floor mirrors offset event comment tag, v1.0.8
 * 2021/03/22 add mirror background image map notetag, v1.0.9
 * 2021/06/19 fix a bug with followers reflection, v1.1.0
 * 2021/08/15 add fix image comment tag and compatibility for big characters, v1.1.2
 * 2021/08/21 fix bug reported by user, v1.1.3
 * 2021/10/12 fix bug reported by user, v1.1.4
 * 2022/08/11 add the option to change the reflection sprites, v1.2.5
 * 
 * This plugin should be installed bellow TSR_MoveEvent for optimal compatibility
 * 
 * =======================================================================================
 * == END ================================================================================                                             
 * =======================================================================================
 *
 *                              "Have fun!"
 *                                                  TSR, The Northern Frog
 *
 * =======================================================================================
 *
 * 
 * @param ---Wall Mirror---
 *
 * @param Wall Mirror Id Type
 * @parent ---Wall Mirror---
 * @type combo
 * @option region id
 * @option tag
 * @desc Use map region Id or terrain tag to mark wall mirrors?
 * @default region id
 * 
 * @param Wall Mirror Region Id
 * @parent ---Wall Mirror---
 * @type Number
 * @min 1
 * @max 255
 * @desc Set the map region Id for wall mirror.
 * @default 253
 * 
 * @param Wall Mirror Terrain Tag
 * @parent ---Wall Mirror---
 * @type Number
 * @min 1
 * @max 7
 * @desc Set the terrain tag for wall mirror.
 * @default 5
 * 
 * @param Wall Mirror X Offset
 * @parent ---Wall Mirror---
 * @desc Set the horizontal offset of the reflection sprites.
 * @default 0
 * 
 * @param Wall Mirror Y Offset
 * @parent ---Wall Mirror---
 * @desc Set the vertical offset of the reflection sprites.
 * @default 0
 * 
 * 
 * @param ---Floor Mirror---
 *
 * @param Floor Mirror Id Type
 * @parent ---Floor Mirror---
 * @type combo
 * @option region id
 * @option tag
 * @desc Use map region Id or terrain tag to mark floor mirrors?
 * @default Region Id
 * 
 * @param Floor Mirror Region Id
 * @parent ---Floor Mirror---
 * @type Number
 * @min 1
 * @max 255
 * @desc Set the map region Id for floor mirror.
 * @default 254
 * 
 * @param Floor Mirror Terrain Tag
 * @parent ---Floor Mirror---
 * @type Number
 * @min 1
 * @max 7
 * @desc Set the terrain tag for floor mirror.
 * @default 6
 * 
 * @param Floor Mirror X Offset
 * @parent ---Floor Mirror---
 * @desc Set the horizontal offset of the reflection sprites.
 * @default 20
 * 
 * @param Floor Mirror Y Offset
 * @parent ---Floor Mirror---
 * @desc Set the vertical offset of the reflection sprites.
 * @default -56
 * 
 * @param Floor Mirror Angle
 * @parent ---Floor Mirror---
 * @desc Set the angle for the reflection sprite rotation.
 * @default 0.3
 *
 * @param Floor Mirror Blur
 * @parent ---Floor Mirror---
 * @desc Set the blur effect strenght of the reflection sprite.
 * @default 1
 * 
 * @param Floor Mirror Opacity
 * @parent ---Floor Mirror---
 * @type Number
 * @min 0
 * @max 255
 * @desc Set the opacity of the reflection sprite.
 * @default 200 
 *  
 * @param Floor Mirror Pulse
 * @parent ---Floor Mirror---
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Enable the pulse effect for the reflection sprite?
 * OFF - false  ON - true
 * @default true
 * 
 *
 */

(() => {
const _0x155279=_0x80dc;(function(_0x719abe,_0x2bec61){const _0x5187ba=_0x80dc,_0x5bfe5c=_0x719abe();while(!![]){try{const _0x556eaf=parseInt(_0x5187ba(0x19d))/0x1+parseInt(_0x5187ba(0x129))/0x2+parseInt(_0x5187ba(0x19a))/0x3*(parseInt(_0x5187ba(0x1dd))/0x4)+-parseInt(_0x5187ba(0x156))/0x5*(-parseInt(_0x5187ba(0x1a7))/0x6)+-parseInt(_0x5187ba(0x17a))/0x7+-parseInt(_0x5187ba(0x1ac))/0x8+-parseInt(_0x5187ba(0x127))/0x9*(parseInt(_0x5187ba(0x1bd))/0xa);if(_0x556eaf===_0x2bec61)break;else _0x5bfe5c['push'](_0x5bfe5c['shift']());}catch(_0x26bdfb){_0x5bfe5c['push'](_0x5bfe5c['shift']());}}}(_0x4364,0xc14ee),TSR[_0x155279(0x13b)]=PluginManager[_0x155279(0x169)](_0x155279(0x12a)),TSR[_0x155279(0x1b5)][_0x155279(0x14e)]=String(TSR[_0x155279(0x13b)][_0x155279(0x1bb)]),TSR[_0x155279(0x1b5)]['_mirrorMapId']=Number(TSR[_0x155279(0x13b)][_0x155279(0x135)]),TSR['mirror']['_mirrorTag']=Number(TSR[_0x155279(0x13b)][_0x155279(0x1ed)]),TSR[_0x155279(0x1b5)][_0x155279(0x1f2)]=String(TSR[_0x155279(0x13b)][_0x155279(0x1e6)]),TSR[_0x155279(0x1b5)][_0x155279(0x185)]=Number(TSR[_0x155279(0x13b)][_0x155279(0x199)]),TSR[_0x155279(0x1b5)]['_reflectTag']=Number(TSR[_0x155279(0x13b)][_0x155279(0x1e4)]),TSR[_0x155279(0x1b5)]['setInfo']=function(_0xd9fdb5){const _0xb7e770=_0x155279;let _0x44c029=_0xd9fdb5===_0xb7e770(0x1b5)?TSR[_0xb7e770(0x1b5)]['_mirrorId']:TSR['mirror']['_reflectId'];if(_0x44c029===_0xb7e770(0x14b)){const _0x49c37a=_0xd9fdb5===_0xb7e770(0x1b5)?TSR['mirror']['_mirrorTag']:TSR['mirror'][_0xb7e770(0x1b3)];return[_0xb7e770(0x1d1),_0x49c37a];}else{const _0x1afbd6=_0xd9fdb5===_0xb7e770(0x1b5)?TSR[_0xb7e770(0x1b5)]['_mirrorMapId']:TSR['mirror'][_0xb7e770(0x185)];return['regionId',_0x1afbd6];}},TSR[_0x155279(0x1b5)]['_mirrorInfo']=TSR[_0x155279(0x1b5)][_0x155279(0x147)](_0x155279(0x1b5)),TSR[_0x155279(0x1b5)][_0x155279(0x1c5)]=TSR[_0x155279(0x1b5)]['setInfo'](_0x155279(0x18d)),TSR[_0x155279(0x1b5)]['_wallOffsetX']=parseInt(String(TSR['Parameters'][_0x155279(0x1aa)])),TSR[_0x155279(0x1b5)][_0x155279(0x1f3)]=parseInt(String(TSR[_0x155279(0x13b)][_0x155279(0x1da)])),TSR[_0x155279(0x1b5)]['_floorOffsetX']=parseInt(String(TSR[_0x155279(0x13b)][_0x155279(0x1a1)])),TSR['mirror'][_0x155279(0x171)]=parseInt(String(TSR[_0x155279(0x13b)]['Floor\x20Mirror\x20Y\x20Offset'])),TSR[_0x155279(0x1b5)][_0x155279(0x1ec)]=parseFloat(String(TSR[_0x155279(0x13b)][_0x155279(0x1c8)])),TSR[_0x155279(0x1b5)][_0x155279(0x12f)]=parseFloat(String(TSR[_0x155279(0x13b)][_0x155279(0x153)])),TSR[_0x155279(0x1b5)][_0x155279(0x174)]=Number(TSR['Parameters'][_0x155279(0x1bf)]),TSR[_0x155279(0x1b5)][_0x155279(0x189)]=eval(String(TSR[_0x155279(0x13b)][_0x155279(0x198)])),DataManager[_0x155279(0x1de)]=function(){const _0x3daf07=_0x155279;if(!$dataMap)return 0x0;const _0x370e47=/<(.*)(?:MIRROR BACKGROUND|MIRROR BACKGROUND):[ ]*(.*(?:\s*,\s*\d+)*)>/i,_0x4abca4=$dataMap[_0x3daf07(0x1a6)][_0x3daf07(0x1d9)]()[_0x3daf07(0x1e3)](/[\r\n]+/);let _0x3b7379=[];for(let _0x3e14db=0x0;_0x3e14db<_0x4abca4['length'];_0x3e14db++){const _0xbc5b65=_0x4abca4[_0x3e14db]['toLowerCase']();if(_0xbc5b65[_0x3daf07(0x128)](_0x370e47)){const _0x5da4c9=_0xbc5b65[_0x3daf07(0x154)](_0x4abca4[_0x3e14db]['indexOf']('<')+0x1,_0xbc5b65[_0x3daf07(0x12b)](_0x3daf07(0x1b1))),_0x51a4b5=_0xbc5b65['slice'](_0x4abca4[_0x3e14db][_0x3daf07(0x12b)](':')+0x1,_0xbc5b65[_0x3daf07(0x12b)]('>'))[_0x3daf07(0x1e3)](',');_0x51a4b5['unshift'](_0x5da4c9),_0x3b7379['push'](_0x51a4b5);}}return _0x3b7379;},DataManager[_0x155279(0x1c9)]=function(_0xcd13d9){const _0x2c00bd=_0x155279;if(!$dataMap)return 0x0;const _0x1030ec=/<(?:FLOOR MIRROR INFO|FLOOR MIRROR):[ ]*(.*(?:\s*,\s*\d+)*)>/i,_0x57c17e=$dataMap['note'][_0x2c00bd(0x1d9)]()[_0x2c00bd(0x1e3)](/[\r\n]+/);for(let _0x3407c4=0x0;_0x3407c4<_0x57c17e[_0x2c00bd(0x1d8)];_0x3407c4++){const _0x23125d=_0x57c17e[_0x3407c4];if(_0x23125d[_0x2c00bd(0x128)](_0x1030ec)&&parseInt(RegExp['$1'])===_0xcd13d9){const _0x57a068=_0x57c17e[_0x3407c4][_0x2c00bd(0x154)](_0x57c17e[_0x3407c4]['indexOf'](':')+0x1,_0x57c17e[_0x3407c4][_0x2c00bd(0x12b)]('>'))[_0x2c00bd(0x1e3)](',');if(parseInt(_0x57a068[0x0])===_0xcd13d9)return _0x57a068;}}return 0x0;},DataManager[_0x155279(0x181)]=function(_0x108ab0){const _0x79d943=_0x155279;if(!_0x108ab0[_0x79d943(0x1ba)])return![];if(!_0x108ab0['page']())return![];const _0x5721d2=/<(?:PICKABLE EVENT|PICKUP EVENT)>/i,_0x1925f0=/<(?:PICKABLE CHARACTER|PICKUP CHARACTER)>/i,_0x4962d0=/<(?:PICKABLE EVENT|PICKUP EVENT):[ ](.)>/i,_0x152ceb=_0x108ab0[_0x79d943(0x164)](),_0x99283f=_0x152ceb[_0x79d943(0x1d8)];for(let _0x70a5f8=0x0;_0x70a5f8<_0x99283f;++_0x70a5f8){let _0x57a118=_0x152ceb[_0x70a5f8];if([0x6c,0x198][_0x79d943(0x1f5)](_0x57a118[_0x79d943(0x14f)])){const _0x35b7a4=_0x57a118[_0x79d943(0x169)][0x0];if(_0x35b7a4['match'](_0x5721d2)||_0x35b7a4[_0x79d943(0x128)](_0x1925f0)||_0x35b7a4['match'](_0x4962d0))return!![];}}return![];},TSR[_0x155279(0x1b5)][_0x155279(0x1e1)]=Scene_Map[_0x155279(0x182)][_0x155279(0x13c)],Scene_Map[_0x155279(0x182)][_0x155279(0x13c)]=function(){const _0x5bd86f=_0x155279;$gamePlayer[_0x5bd86f(0x1e5)](![]),$gamePlayer[_0x5bd86f(0x184)](![]);for(const _0xfe332f of $gamePlayer[_0x5bd86f(0x178)]()[_0x5bd86f(0x139)]){_0xfe332f[_0x5bd86f(0x1e5)](![]),_0xfe332f['setPreventReflect'](![]);}for(const _0x4586f8 of $gameMap[_0x5bd86f(0x1e2)]()){_0x4586f8[_0x5bd86f(0x1e5)](![]),_0x4586f8[_0x5bd86f(0x184)](![]);}TSR[_0x5bd86f(0x1b5)][_0x5bd86f(0x1e1)][_0x5bd86f(0x14c)](this);},Game_Map['prototype'][_0x155279(0x180)]=function(_0x85c72a,_0x539b88){const _0x16ca71=_0x155279,_0x4f1886=TSR[_0x16ca71(0x1b5)][_0x16ca71(0x1b9)][0x0],_0x2daaa5=TSR[_0x16ca71(0x1b5)][_0x16ca71(0x1b9)][0x1];return this[_0x4f1886](_0x85c72a-0x1,_0x539b88)===_0x2daaa5||this[_0x4f1886](_0x85c72a+0x1,_0x539b88)===_0x2daaa5||this[_0x4f1886](_0x85c72a,_0x539b88)===_0x2daaa5;},Game_Character[_0x155279(0x182)]['checkMirrorTiles']=function(_0xecf443,_0x3b70ac){const _0x27a839=_0x155279;if(this[_0x27a839(0x175)](_0xecf443,_0x3b70ac)){const _0x5525b8=this[_0x27a839(0x16e)](_0xecf443,_0x3b70ac);return this['isNearMirrorTile'](_0xecf443,_0x3b70ac,_0x5525b8);}return![];},Game_Character['prototype'][_0x155279(0x175)]=function(_0x26276d,_0x4fffc7){return this['isMirrorColumn'](_0x26276d,_0x4fffc7);},Game_Character['prototype']['isMirrorColumn']=function(_0x2342af,_0x408928){const _0x25ef08=_0x155279;for(let _0x2b5363=_0x408928;_0x2b5363>0x0;_0x2b5363--){if($gameMap[_0x25ef08(0x180)](_0x2342af,_0x2b5363))return!![];}return![];},Game_Character[_0x155279(0x182)][_0x155279(0x149)]=function(_0x1f123d,_0x298332,_0x4500be){const _0x167eb5=_0x155279;return this[_0x167eb5(0x163)](_0x1f123d,_0x298332,_0x4500be)?this[_0x167eb5(0x1e9)]=!![]:this[_0x167eb5(0x1e9)]=![],this[_0x167eb5(0x1e9)];},Game_Character[_0x155279(0x182)]['checkMirrorY']=function(_0x223c0f,_0xd9d741,_0x3896cd){for(let _0x56fad1=_0xd9d741;_0x56fad1>_0xd9d741-_0x3896cd-0x1;_0x56fad1--){if($gameMap['isFrontMirrorTile'](_0x223c0f,_0x56fad1))return!![];}return![];},Game_Character['prototype'][_0x155279(0x16e)]=function(_0x393045,_0x523be0){const _0x54d677=_0x155279;this[_0x54d677(0x16b)]();for(let _0x3d08dd=_0x523be0;_0x3d08dd>0x0;_0x3d08dd--){if($gameMap[_0x54d677(0x180)](_0x393045,_0x3d08dd)){if(!this[_0x54d677(0x15c)]())this[_0x54d677(0x17d)]=_0x3d08dd;}else{if(!this['topMirrorY']()&&this[_0x54d677(0x15c)]()){this[_0x54d677(0x14d)]=_0x3d08dd+0x1;break;}}}return this['_bottomMirrorY']-this['_topMirrorY']+0x2;},Game_Character[_0x155279(0x182)][_0x155279(0x15c)]=function(){return this['_bottomMirrorY'];},Game_Character[_0x155279(0x182)][_0x155279(0x155)]=function(){const _0x48212d=_0x155279;return this[_0x48212d(0x14d)];},Game_Character[_0x155279(0x182)][_0x155279(0x12d)]=function(_0x4b562d,_0x782394){const _0x4c9a27=_0x155279;return this[_0x4c9a27(0x1c3)](_0x4b562d,_0x782394);},Game_Character[_0x155279(0x182)][_0x155279(0x1c3)]=function(_0x296ff1,_0x76c493){const _0x525571=_0x155279,_0x93baaa=$gameMap[_0x525571(0x16a)](_0x296ff1,0x4),_0x4f9216=$gameMap['roundXWithDirection'](_0x296ff1,0x6),_0x108550=$gameMap[_0x525571(0x16a)](_0x93baaa,0x4),_0x25bd26=$gameMap[_0x525571(0x16a)](_0x4f9216,0x6);return this[_0x525571(0x172)](_0x296ff1,_0x76c493)||this[_0x525571(0x172)](_0x93baaa,_0x76c493)||this[_0x525571(0x172)](_0x4f9216,_0x76c493)||this[_0x525571(0x172)](_0x108550,_0x76c493)||this[_0x525571(0x172)](_0x25bd26,_0x76c493);},Game_Character[_0x155279(0x182)][_0x155279(0x172)]=function(_0x2c208b,_0x4d137a){const _0x5aad25=_0x155279,_0x484808=this[_0x5aad25(0x162)](_0x2c208b,_0x4d137a),_0x158a4b=_0x484808?_0x5aad25(0x176):TSR['mirror']['_reflectInfo'][0x0],_0x24aadd=_0x484808?parseInt(_0x484808[0x0]):TSR[_0x5aad25(0x1b5)]['_reflectInfo'][0x1];return $gameMap[_0x158a4b](_0x2c208b,_0x4d137a)===_0x24aadd||$gameMap[_0x158a4b](_0x2c208b,_0x4d137a-0x1)===_0x24aadd||$gameMap[_0x158a4b](_0x2c208b,_0x4d137a-0x2)===_0x24aadd||$gameMap[_0x158a4b](_0x2c208b,_0x4d137a+0x1)===_0x24aadd||$gameMap[_0x158a4b](_0x2c208b,_0x4d137a+0x2)===_0x24aadd;},Game_Character[_0x155279(0x182)][_0x155279(0x162)]=function(_0x157110,_0x114fef){const _0x194d07=_0x155279;for(let _0x3798bb=-0x2;_0x3798bb<0x2;_0x3798bb++){ar=DataManager['getMapMirrorInfos']($gameMap[_0x194d07(0x176)](_0x157110,_0x114fef+_0x3798bb));if(ar)return this[_0x194d07(0x159)](ar),ar;}return this[_0x194d07(0x159)](![]),![];},TSR[_0x155279(0x1b5)][_0x155279(0x188)]=Game_Character['prototype'][_0x155279(0x1af)],Game_Character[_0x155279(0x182)]['update']=function(){const _0x3a14ac=_0x155279;TSR[_0x3a14ac(0x1b5)][_0x3a14ac(0x188)]['call'](this);if(!this[_0x3a14ac(0x140)]()){if(this[_0x3a14ac(0x17c)](this['x'],this['y'])&&this[_0x3a14ac(0x1a0)]()){this[_0x3a14ac(0x1f0)](!![]);if(Imported['TSR_MoveEvent']){if(this['isPlayer']()&&this[_0x3a14ac(0x1f4)]){const _0x45a318=this[_0x3a14ac(0x1b0)]();if(!_0x45a318[_0x3a14ac(0x1a8)]())_0x45a318['setMirror'](!![]);}}}if(this[_0x3a14ac(0x12d)](this['x'],this['y'])&&this['canReflect']()){this[_0x3a14ac(0x15a)](!![]);if(Imported[_0x3a14ac(0x1c4)]){if(this[_0x3a14ac(0x1d6)]()&&this[_0x3a14ac(0x1f4)]){const _0x453cea=this[_0x3a14ac(0x1b0)]();if(!_0x453cea[_0x3a14ac(0x13e)]())_0x453cea[_0x3a14ac(0x15a)](!![]);}}}}},Game_Character[_0x155279(0x182)][_0x155279(0x1a0)]=function(){const _0x19a057=_0x155279;if(this[_0x19a057(0x192)]&&!this[_0x19a057(0x151)]())return![];return!this[_0x19a057(0x1a8)]();},Game_Character[_0x155279(0x182)][_0x155279(0x1be)]=function(){const _0x522844=_0x155279;if(this[_0x522844(0x192)]&&!this[_0x522844(0x151)]())return![];return!this['preventReflect']();},Game_Character[_0x155279(0x182)][_0x155279(0x1b4)]=function(){const _0x4904f6=_0x155279;return this[_0x4904f6(0x17b)]-this[_0x4904f6(0x17d)];},Game_Character[_0x155279(0x182)][_0x155279(0x1d7)]=function(){const _0x29de34=_0x155279;return this[_0x29de34(0x136)];},Game_Character[_0x155279(0x182)][_0x155279(0x1f0)]=function(_0x3a7258){const _0x5496d6=_0x155279;this[_0x5496d6(0x136)]=_0x3a7258;},Game_Character[_0x155279(0x182)][_0x155279(0x1c7)]=function(){return this['_needsReflect'];},Game_Character[_0x155279(0x182)][_0x155279(0x15a)]=function(_0x553b77){this['_needsReflect']=_0x553b77;},Game_Character[_0x155279(0x182)]['setCurrentMirrorInfo']=function(_0x342406){const _0x53c99b=_0x155279;this[_0x53c99b(0x18f)]=_0x342406;},Game_Character[_0x155279(0x182)][_0x155279(0x1e0)]=function(){const _0x2a5dca=_0x155279;return this[_0x2a5dca(0x18f)];},Game_Character[_0x155279(0x182)][_0x155279(0x183)]=function(){const _0x1dd3a5=_0x155279;return this[_0x1dd3a5(0x137)];},Game_Character[_0x155279(0x182)][_0x155279(0x132)]=function(_0xc3f5cf){const _0x652a13=_0x155279;this[_0x652a13(0x137)]=_0xc3f5cf;},Game_Character[_0x155279(0x182)][_0x155279(0x1a8)]=function(){return this['_preventMirror'];},Game_Character[_0x155279(0x182)][_0x155279(0x1e5)]=function(_0x5324d7){const _0x4d8659=_0x155279;this[_0x4d8659(0x187)]=_0x5324d7;},Game_Character['prototype'][_0x155279(0x13e)]=function(){const _0x4a3b4b=_0x155279;return this[_0x4a3b4b(0x143)];},Game_Character[_0x155279(0x182)][_0x155279(0x184)]=function(_0x1aba06){const _0xce364c=_0x155279;this[_0xce364c(0x143)]=_0x1aba06;},Game_Character[_0x155279(0x182)][_0x155279(0x140)]=function(){return this['_cannotMirror'];},Game_Character['prototype'][_0x155279(0x165)]=function(){const _0x36aa21=_0x155279;return this[_0x36aa21(0x168)];},Game_Character[_0x155279(0x182)][_0x155279(0x195)]=function(){const _0x38312c=_0x155279;return this[_0x38312c(0x1e9)];},Game_Character[_0x155279(0x182)][_0x155279(0x16b)]=function(){const _0x35a7f6=_0x155279;this[_0x35a7f6(0x17d)]=![],this[_0x35a7f6(0x14d)]=![];},TSR['mirror'][_0x155279(0x191)]=Game_Event['prototype'][_0x155279(0x196)],Game_Event['prototype'][_0x155279(0x196)]=function(){const _0x1ecf4d=_0x155279;TSR[_0x1ecf4d(0x1b5)]['_Game_Event_setupPage']['call'](this),this[_0x1ecf4d(0x138)]();},Game_Event[_0x155279(0x182)][_0x155279(0x138)]=function(){const _0x19b837=_0x155279;if(!this[_0x19b837(0x144)]())return;const _0x44688b=/<(?:CANNOT MIRROR EVENT|NO MIRROR)>/i,_0x2804c3=/<(?:WALL MIRROR OFFSET|WALL OFFSET):[ ]-*(\d+),[ ]-*(\d+)>/i,_0x500c60=/<(?:FLOOR MIRROR OFFSET|WATER REFLECT OFFSET):[ ]-*(\d+),[ ]-*(\d+)>/i,_0x3ddea1=/<(?:FIX MIRROR IMAGE|FIX IMAGE|FIX MIRROR)>/i,_0x53c3a5=this[_0x19b837(0x164)](),_0x4f9fdc=_0x53c3a5['length'];this['_cannotMirror']=![],this['_wallMirrorOffset']=![],this['_floorMirrorOffset']=![],this['_fixMirrorImage']=![];for(let _0x1aaba3=0x0;_0x1aaba3<_0x4f9fdc;++_0x1aaba3){let _0x53949a=_0x53c3a5[_0x1aaba3];if([0x6c,0x198][_0x19b837(0x1f5)](_0x53949a[_0x19b837(0x14f)])){const _0x2897f9=_0x53949a[_0x19b837(0x169)][0x0];if(_0x2897f9[_0x19b837(0x128)](_0x44688b))this['_cannotMirror']=!![];else{if(_0x2897f9[_0x19b837(0x128)](_0x2804c3)){const _0x527e9e=parseInt(_0x2897f9[_0x19b837(0x154)](_0x2897f9[_0x19b837(0x12b)](':')+0x1,_0x2897f9[_0x19b837(0x12b)](','))),_0x50cc18=parseInt(_0x2897f9['slice'](_0x2897f9[_0x19b837(0x12b)](',')+0x1,_0x2897f9[_0x19b837(0x12b)]('>')));this[_0x19b837(0x15e)]=[_0x527e9e,_0x50cc18];}else{if(_0x2897f9['match'](_0x500c60)){const _0x5cd2c=parseInt(_0x2897f9['slice'](_0x2897f9[_0x19b837(0x12b)](':')+0x1,_0x2897f9['indexOf'](','))),_0x4dd655=parseInt(_0x2897f9[_0x19b837(0x154)](_0x2897f9['indexOf'](',')+0x1,_0x2897f9[_0x19b837(0x12b)]('>')));this['_floorMirrorOffset']=[_0x5cd2c,_0x4dd655];}else _0x2897f9[_0x19b837(0x128)](_0x3ddea1)&&(this[_0x19b837(0x168)]=!![]);}}}}},TSR[_0x155279(0x1b5)][_0x155279(0x12e)]=Spriteset_Map[_0x155279(0x182)]['createLowerLayer'],Spriteset_Map[_0x155279(0x182)][_0x155279(0x1a9)]=function(){const _0x4f8c69=_0x155279;TSR[_0x4f8c69(0x1b5)][_0x4f8c69(0x12e)][_0x4f8c69(0x14c)](this),this[_0x4f8c69(0x1b8)]();},Spriteset_Map[_0x155279(0x182)]['createMirrorBackGroundSprites']=function(){const _0x5eac42=_0x155279,_0x34dea2=DataManager[_0x5eac42(0x1de)]();this[_0x5eac42(0x146)]=[];if(_0x34dea2[_0x5eac42(0x1d8)]>0x0)for(const _0x35947d of _0x34dea2){const _0x4f9fee=_0x35947d[0x0][_0x5eac42(0x1db)](),_0x3eb623=_0x35947d[0x1]['trim'](),_0x4a50f2=parseFloat(_0x35947d[0x2]),_0x14d2e5=parseFloat(_0x35947d[0x3]),_0x332eea=parseFloat(_0x35947d[0x4]);this[_0x5eac42(0x130)](_0x4f9fee,_0x3eb623,_0x4a50f2,_0x14d2e5,_0x332eea);}},Spriteset_Map[_0x155279(0x182)][_0x155279(0x130)]=function(_0x1cc252,_0x57026d,_0x374d9f,_0x543a34,_0x4a7cf8){const _0x42a65d=_0x155279,_0x558875='-'+_0x1cc252+'MirrorBg';this[_0x558875]=new Sprite(),this[_0x558875][_0x42a65d(0x1ef)]=ImageManager[_0x42a65d(0x1ca)](_0x57026d),this[_0x558875][_0x42a65d(0x1df)](0x0,0x0,this[_0x42a65d(0x1f7)],this[_0x42a65d(0x1eb)]),this[_0x558875][_0x42a65d(0x1cc)]=_0x374d9f,this[_0x558875][_0x42a65d(0x19f)]=_0x543a34,this[_0x558875]['z']=_0x4a7cf8,this['_tilemap'][_0x42a65d(0x152)](this[_0x558875]),this[_0x42a65d(0x146)]['push'](this[_0x558875]);},TSR[_0x155279(0x1b5)]['_Spriteset_Map_update']=Spriteset_Map['prototype'][_0x155279(0x1af)],Spriteset_Map[_0x155279(0x182)][_0x155279(0x1af)]=function(){const _0x342991=_0x155279;TSR['mirror'][_0x342991(0x133)][_0x342991(0x14c)](this),this[_0x342991(0x1ea)]();},Spriteset_Map[_0x155279(0x182)]['updateMirrorBackground']=function(){const _0x2e984d=_0x155279;for(const _0x24ff98 in this[_0x2e984d(0x146)]){const _0x807d22=this[_0x2e984d(0x146)][_0x24ff98],_0x583b77=$gameMap[_0x2e984d(0x1b7)](),_0x28e3fc=$gameMap[_0x2e984d(0x197)]();_0x807d22['x']=_0x807d22[_0x2e984d(0x1cc)]*_0x583b77-$gameMap[_0x2e984d(0x1cc)]*_0x583b77,_0x807d22['y']=_0x807d22[_0x2e984d(0x19f)]*_0x28e3fc-$gameMap[_0x2e984d(0x19f)]*_0x28e3fc;}},TSR[_0x155279(0x1b5)]['_Sprite_Character_initMembers']=Sprite_Character[_0x155279(0x182)][_0x155279(0x190)],Sprite_Character[_0x155279(0x182)][_0x155279(0x190)]=function(){const _0x45f1c5=_0x155279;TSR[_0x45f1c5(0x1b5)][_0x45f1c5(0x1c0)][_0x45f1c5(0x14c)](this),this[_0x45f1c5(0x1ce)]=[],this[_0x45f1c5(0x177)]=[];},TSR['mirror'][_0x155279(0x1d2)]=Sprite_Character[_0x155279(0x182)][_0x155279(0x1af)],Sprite_Character[_0x155279(0x182)][_0x155279(0x1af)]=function(){const _0x82a2e4=_0x155279;TSR[_0x82a2e4(0x1b5)]['_Sprite_Character_update'][_0x82a2e4(0x14c)](this),this['updateMirrorSprites']();},Sprite_Character['prototype']['updateMirrorSprites']=function(){const _0x434287=_0x155279;this[_0x434287(0x1a2)](),this[_0x434287(0x1ce)][_0x434287(0x1d8)]>0x0&&(!this[_0x434287(0x1ce)][0x0][_0x434287(0x173)]()&&(this[_0x434287(0x16d)][_0x434287(0x16f)](this[_0x434287(0x1ce)][0x0]),this[_0x434287(0x1ce)][_0x434287(0x194)](),this['_character'][_0x434287(0x1e5)](![]),this[_0x434287(0x157)]['resetMirrorBottomTop'](),this[_0x434287(0x157)][_0x434287(0x1e9)]=![])),this[_0x434287(0x15b)](),this[_0x434287(0x177)][_0x434287(0x1d8)]>0x0&&(!this[_0x434287(0x177)][0x0]['isPlaying']()&&(this['parent'][_0x434287(0x16f)](this[_0x434287(0x177)][0x0]),this[_0x434287(0x177)][_0x434287(0x194)](),this[_0x434287(0x157)][_0x434287(0x184)](![])));},Sprite_Character['prototype'][_0x155279(0x1a2)]=function(){const _0x2baf0a=_0x155279;this[_0x2baf0a(0x157)][_0x2baf0a(0x1d7)]()&&(this['_character']['setMirror'](![]),this[_0x2baf0a(0x157)][_0x2baf0a(0x1e5)](!![]),this[_0x2baf0a(0x1cf)]());},Sprite_Character[_0x155279(0x182)]['startMirror']=function(){const _0x5824e8=_0x155279,_0x2c967b=this['createMirrorSprite']();this[_0x5824e8(0x1ce)][_0x5824e8(0x1ee)](_0x2c967b);},Sprite_Character[_0x155279(0x182)][_0x155279(0x17e)]=function(){const _0x2d1fbe=_0x155279,_0x99d4dd=new Sprite_Mirror();return _0x99d4dd['x']=this['_character'][_0x2d1fbe(0x148)](),_0x99d4dd['y']=this[_0x2d1fbe(0x157)][_0x2d1fbe(0x13f)](),_0x99d4dd[_0x2d1fbe(0x141)](this,this[_0x2d1fbe(0x157)]),this[_0x2d1fbe(0x16d)][_0x2d1fbe(0x152)](_0x99d4dd),_0x99d4dd;},Sprite_Character[_0x155279(0x182)][_0x155279(0x15b)]=function(){const _0x29d384=_0x155279;this[_0x29d384(0x157)][_0x29d384(0x1c7)]()&&(this[_0x29d384(0x157)][_0x29d384(0x15a)](![]),this[_0x29d384(0x157)][_0x29d384(0x184)](!![]),this[_0x29d384(0x1a3)]());},Sprite_Character['prototype']['startReflect']=function(){const _0x1e9b42=_0x155279,_0x117232=this[_0x1e9b42(0x150)]();this[_0x1e9b42(0x177)]['push'](_0x117232);},Sprite_Character['prototype'][_0x155279(0x150)]=function(){const _0x326768=_0x155279,_0x1274ab=$gameMap['tileWidth'](),_0x4cb0d9=new Sprite_Reflect();return _0x4cb0d9['x']=-_0x1274ab,_0x4cb0d9['y']=-_0x1274ab,_0x4cb0d9[_0x326768(0x141)](this,this[_0x326768(0x157)]),this[_0x326768(0x16d)][_0x326768(0x152)](_0x4cb0d9),_0x4cb0d9;});function Sprite_Mirror(){const _0x47f66f=_0x155279;this[_0x47f66f(0x134)][_0x47f66f(0x1cd)](this,arguments);}function _0x4364(){const _0x2e4c4c=['tag','call','_topMirrorY','_mirrorId','code','createReflectSprite','isVisible','addChild','Floor\x20Mirror\x20Blur','slice','topMirrorY','5mpRxEq','_character','_filter','setCurrentMirrorInfo','setReflect','setupReflect','bottomMirrorY','rotation','_wallMirrorOffset','_scale','tileId','tileset','checkMapMirrorInfos','checkMirrorY','list','checkFixMirrorTag','loadTileset','updateContainerZ','_fixMirrorImage','parameters','roundXWithDirection','resetMirrorBottomTop','distBottom','parent','calcMirrorHeight','removeChild','updateTileFrame','_floorOffsetY','checkReflectY','isPlaying','_opacity','isFrontOfMirror','regionId','_reflectSpriteSet','followers','_frameCount','4556818VGxwQf','_realY','checkMirrorTiles','_bottomMirrorY','createMirrorSprite','_offsetY','isFrontMirrorTile','isPickupEvent','prototype','reflectionChar','setPreventReflect','_reflectMapId','create','_preventMirror','_Game_Character_update','_pulse','filters','anchor','loadCharacter','reflect','_characterName','_currentMirrorInfo','initMembers','_Game_Event_setupPage','_memberIndex','isTransparent','shift','inFrontOfMirror','setupPage','tileHeight','Floor\x20Mirror\x20Pulse','Floor\x20Mirror\x20Region\x20Id','1608zgVnHN','pushDist','hasBitmap','995045NZMHGL','_grow','_displayY','canMirror','Floor\x20Mirror\x20X\x20Offset','setupMirror','startReflect','_tilesetId','updateScale','note','9326334NNJwDL','preventMirror','createLowerLayer','Wall\x20Mirror\x20X\x20Offset','_offsetX','7539672AylnVU','characterName','blur','update','pickupEvent','mirror\x20background','backDist','_reflectTag','distToBottomMirror','mirror','_patternW','tileWidth','createMirrorBackGroundSprites','_mirrorInfo','_eventId','Wall\x20Mirror\x20Id\x20Type','_characterIndex','13708970uLcuil','canReflect','Floor\x20Mirror\x20Opacity','_Sprite_Character_initMembers','_rChar','_originalScaleX','isNearReflectTile','TSR_MoveEvent','_reflectInfo','isBigCharacter','needsReflect','Floor\x20Mirror\x20Angle','getMapMirrorInfos','loadParallax','opacity','_displayX','apply','_mirrorSpriteSet','startMirror','direction','terrainTag','_Sprite_Character_update','updateCharacterMove','setData','constructor','isPlayer','needsMirror','length','toString','Wall\x20Mirror\x20Y\x20Offset','trim','tilesetId','1324BEssQO','getMapBackGround','setFrame','currentMirrorInfo','Scene_Map_terminate','events','split','Floor\x20Mirror\x20Terrain\x20Tag','setPreventMirror','Floor\x20Mirror\x20Id\x20Type','tilesetNames','pullDist','_inFrontOfMirror','updateMirrorBackground','height','_angle','Wall\x20Mirror\x20Terrain\x20Tag','push','bitmap','setMirror','_patternH','_reflectId','_wallOffsetY','_hasPickup','contains','_tileId','width','characterIndex','9fZbRLk','match','2058540TFvyYw','TSR_Mirror','indexOf','updateCharacterFrame','checkReflectTiles','_Spriteset_Map_createLowerLayer','_blur','addMirrorBackground','floor','setReflectionChar','_Spriteset_Map_update','initialize','Wall\x20Mirror\x20Region\x20Id','_needsMirror','_reflectionChar','checkMirrorEventTags','_data','pattern','Parameters','terminate','tilesetBitmap','preventReflect','screenY','checkCannotMirrorTag','setup','scale','_preventReflect','page','BlurFilter','_mirrorBGArray','setInfo','screenX','isNearMirrorTile','_spriteChar'];_0x4364=function(){return _0x2e4c4c;};return _0x4364();}function _0x80dc(_0x50de29,_0x2f7028){const _0x43648a=_0x4364();return _0x80dc=function(_0x80dcdf,_0x126bdd){_0x80dcdf=_0x80dcdf-0x127;let _0x4e8cf0=_0x43648a[_0x80dcdf];return _0x4e8cf0;},_0x80dc(_0x50de29,_0x2f7028);}Sprite_Mirror['prototype']=Object[_0x155279(0x186)](Sprite[_0x155279(0x182)]),Sprite_Mirror['prototype'][_0x155279(0x1d5)]=Sprite_Mirror,Sprite_Mirror[_0x155279(0x182)][_0x155279(0x134)]=function(){const _0x438579=_0x155279;Sprite['prototype'][_0x438579(0x134)][_0x438579(0x14c)](this),this[_0x438579(0x190)]();},Sprite_Mirror[_0x155279(0x182)]['initMembers']=function(){const _0x77e9a9=_0x155279;this[_0x77e9a9(0x18b)]['x']=0.5,this['anchor']['y']=0x0,this['z']=-0.5,this[_0x77e9a9(0x1ab)]=TSR[_0x77e9a9(0x1b5)]['_wallOffsetX'],this[_0x77e9a9(0x17f)]=TSR[_0x77e9a9(0x1b5)][_0x77e9a9(0x1f3)];},Sprite_Mirror[_0x155279(0x182)][_0x155279(0x141)]=function(_0x56f59d,_0x1c46d7){const _0x3fae9a=_0x155279,_0x4d20ac=_0x1c46d7[_0x3fae9a(0x15e)];_0x4d20ac&&(this[_0x3fae9a(0x1ab)]=_0x4d20ac[0x0],this[_0x3fae9a(0x17f)]=_0x4d20ac[0x1]);const _0x35f44c=_0x1c46d7[_0x3fae9a(0x183)](),_0x16904a=_0x35f44c?_0x35f44c[0x0]:null,_0x11a443=_0x35f44c?_0x35f44c[0x1]:null;this['_rChar']=_0x35f44c,this[_0x3fae9a(0x14a)]=_0x56f59d,this[_0x3fae9a(0x157)]=_0x1c46d7,this[_0x3fae9a(0x18e)]=_0x16904a||_0x1c46d7[_0x3fae9a(0x18e)],this[_0x3fae9a(0x1bc)]=_0x11a443||_0x1c46d7[_0x3fae9a(0x1bc)];_0x1c46d7['_scale']&&(this[_0x3fae9a(0x142)]['x']=_0x1c46d7[_0x3fae9a(0x15f)],this[_0x3fae9a(0x142)]['y']=_0x1c46d7[_0x3fae9a(0x15f)],this[_0x3fae9a(0x1ab)]*=_0x1c46d7['_scale'],this[_0x3fae9a(0x17f)]*=_0x1c46d7[_0x3fae9a(0x15f)]);const _0x43d907=ImageManager[_0x3fae9a(0x1c6)](this['_characterName']);this[_0x3fae9a(0x1b6)]=_0x43d907?0x3:0xc,this[_0x3fae9a(0x1f1)]=_0x43d907?0x4:0x8,_0x1c46d7[_0x3fae9a(0x1f6)]>0x0?(this['_tileId']=_0x1c46d7[_0x3fae9a(0x1f6)],this[_0x3fae9a(0x1ef)]=this[_0x3fae9a(0x13d)](this[_0x3fae9a(0x1f6)]),this['updateTileFrame']()):(this[_0x3fae9a(0x1ef)]=ImageManager[_0x3fae9a(0x18c)](this['_characterName']),this['updateCharacterFrame']()),this[_0x3fae9a(0x1d3)]();},Sprite_Mirror[_0x155279(0x182)][_0x155279(0x16c)]=function(){const _0x23e718=_0x155279,_0x3f3ee3=this[_0x23e718(0x157)][_0x23e718(0x1b4)]()*$gameMap['tileWidth']();return _0x3f3ee3;},Sprite_Mirror[_0x155279(0x182)][_0x155279(0x1af)]=function(){const _0x296e13=_0x155279;Sprite[_0x296e13(0x182)][_0x296e13(0x1af)]['call'](this),this[_0x296e13(0x157)][_0x296e13(0x160)]()>0x0?this[_0x296e13(0x170)]():this[_0x296e13(0x12c)](),this['updateCharacterMove'](),this['visible']=!this[_0x296e13(0x157)][_0x296e13(0x193)]()&&this['hasBitmap']();},Sprite_Mirror['prototype'][_0x155279(0x13d)]=function(_0x476bfa){const _0x111eb7=_0x155279,_0x5468c7=$gameMap[_0x111eb7(0x161)](),_0x59566e=0x5+Math[_0x111eb7(0x131)](_0x476bfa/0x100);return ImageManager[_0x111eb7(0x166)](_0x5468c7[_0x111eb7(0x1e7)][_0x59566e]);},Sprite_Mirror[_0x155279(0x182)][_0x155279(0x170)]=function(){const _0x1b5cb0=_0x155279,_0x2fd5e1=this['_tileId'],_0x45673c=$gameMap[_0x1b5cb0(0x1b7)](),_0x39fa23=$gameMap[_0x1b5cb0(0x197)](),_0x30dfca=(Math[_0x1b5cb0(0x131)](_0x2fd5e1/0x80)%0x2*0x8+_0x2fd5e1%0x8)*_0x45673c,_0x480f3a=Math['floor'](_0x2fd5e1%0x100/0x8)%0x10*_0x39fa23;this[_0x1b5cb0(0x1df)](_0x30dfca,_0x480f3a,_0x45673c,_0x39fa23);},Sprite_Mirror[_0x155279(0x182)][_0x155279(0x12c)]=function(){const _0x27b1a0=_0x155279,_0x5551fc=this['_characterIndex'];let _0x24215a=this[_0x27b1a0(0x157)]['direction']();!this['_character']['_isPickable']&&!this[_0x27b1a0(0x157)][_0x27b1a0(0x165)]()&&(_0x24215a=this[_0x27b1a0(0x157)][_0x27b1a0(0x1d0)]()===0x2||this[_0x27b1a0(0x157)]['direction']()===0x8?0xa-this[_0x27b1a0(0x157)][_0x27b1a0(0x1d0)]():this[_0x27b1a0(0x157)][_0x27b1a0(0x1d0)]());const _0x34b7e1=this['bitmap'][_0x27b1a0(0x1f7)]/this['_patternW'],_0x480e79=this['bitmap'][_0x27b1a0(0x1eb)]/this[_0x27b1a0(0x1f1)],_0x5cbfa7=(_0x5551fc%0x4*0x3+this[_0x27b1a0(0x157)][_0x27b1a0(0x13a)]())*_0x34b7e1,_0x58db3a=(Math['floor'](_0x5551fc/0x4)*0x4+(_0x24215a-0x2)/0x2)*_0x480e79;this['setFrame'](_0x5cbfa7,_0x58db3a,_0x34b7e1,_0x480e79);},Sprite_Mirror[_0x155279(0x182)][_0x155279(0x1d3)]=function(){const _0x2e5b42=_0x155279,_0x10fb0f=this[_0x2e5b42(0x17f)]-this[_0x2e5b42(0x16c)]()*0x2;if(Imported[_0x2e5b42(0x1c4)]){let _0x43badf=0x2*(this[_0x2e5b42(0x14a)]['y']-this[_0x2e5b42(0x157)][_0x2e5b42(0x13f)]());if(this[_0x2e5b42(0x157)]['pushDist']()||this[_0x2e5b42(0x157)][_0x2e5b42(0x1e8)]()||this[_0x2e5b42(0x157)][_0x2e5b42(0x1b2)]())this['x']=this[_0x2e5b42(0x14a)]['x']+this[_0x2e5b42(0x1ab)],this['y']=this[_0x2e5b42(0x14a)]['y']-_0x43badf+_0x10fb0f;else{const _0x3ec4e2=$gamePlayer[_0x2e5b42(0x1d0)](),_0xa45146=this[_0x2e5b42(0x157)]['isPickup'](),_0x2e6e06=_0xa45146?_0x3ec4e2===0x4||_0x3ec4e2===0x6?0xc:0x7:0x0;this['x']=this[_0x2e5b42(0x157)][_0x2e5b42(0x148)]()+this[_0x2e5b42(0x1ab)],this['y']=this[_0x2e5b42(0x157)][_0x2e5b42(0x13f)]()+_0x10fb0f-_0x2e6e06*0x2;}}else this['x']=this['_character'][_0x2e5b42(0x148)]()+this[_0x2e5b42(0x1ab)],this['y']=this[_0x2e5b42(0x157)][_0x2e5b42(0x13f)]()+_0x10fb0f;},Sprite_Mirror[_0x155279(0x182)][_0x155279(0x19c)]=function(){const _0x4b607e=_0x155279,_0x23e789=this[_0x4b607e(0x157)]['reflectionChar']()?this['_characterName']===this['_character']['reflectionChar']()[0x0]:this[_0x4b607e(0x18e)]===this[_0x4b607e(0x157)]['characterName'](),_0x377105=this[_0x4b607e(0x157)][_0x4b607e(0x183)]()?this[_0x4b607e(0x1bc)]===this[_0x4b607e(0x157)][_0x4b607e(0x183)]()[0x1]:this[_0x4b607e(0x1bc)]===this[_0x4b607e(0x157)][_0x4b607e(0x1f8)]();return _0x23e789&&_0x377105||(this[_0x4b607e(0x1a4)]===$gameMap[_0x4b607e(0x1dc)]()||this[_0x4b607e(0x1f6)]===this[_0x4b607e(0x157)][_0x4b607e(0x160)]());},Sprite_Mirror[_0x155279(0x182)][_0x155279(0x173)]=function(){const _0x1759dc=_0x155279;return this[_0x1759dc(0x157)][_0x1759dc(0x17c)](this[_0x1759dc(0x157)]['x'],this[_0x1759dc(0x157)]['y'])&&this[_0x1759dc(0x19c)]();};function Sprite_Reflect(){const _0x2067b2=_0x155279;this[_0x2067b2(0x134)][_0x2067b2(0x1cd)](this,arguments);}Sprite_Reflect[_0x155279(0x182)]=Object[_0x155279(0x186)](Sprite[_0x155279(0x182)]),Sprite_Reflect[_0x155279(0x182)][_0x155279(0x1d5)]=Sprite_Reflect,Sprite_Reflect[_0x155279(0x182)][_0x155279(0x134)]=function(){const _0x10cf53=_0x155279;Sprite[_0x10cf53(0x182)][_0x10cf53(0x134)]['call'](this),this['initMembers']();},Sprite_Reflect['prototype']['initMembers']=function(){const _0x1c8fb8=_0x155279;this[_0x1c8fb8(0x18b)]['x']=0.5,this[_0x1c8fb8(0x18b)]['y']=0.5,this['z']=-0.6;},Sprite_Reflect['prototype'][_0x155279(0x1d4)]=function(_0x4df6bb){const _0x5d974d=_0x155279;_0x4df6bb?(this['_offsetX']=parseInt(_0x4df6bb[0x1]),this[_0x5d974d(0x17f)]=parseInt(_0x4df6bb[0x2]),this[_0x5d974d(0x1ec)]=parseFloat(_0x4df6bb[0x3]),this[_0x5d974d(0x12f)]=parseFloat(_0x4df6bb[0x4]),this[_0x5d974d(0x1cb)]=parseInt(_0x4df6bb[0x5]),this[_0x5d974d(0x189)]=_0x4df6bb[0x6]):(this[_0x5d974d(0x1ab)]=TSR[_0x5d974d(0x1b5)]['_floorOffsetX'],this[_0x5d974d(0x17f)]=TSR[_0x5d974d(0x1b5)][_0x5d974d(0x171)],this[_0x5d974d(0x1ec)]=TSR[_0x5d974d(0x1b5)][_0x5d974d(0x1ec)],this[_0x5d974d(0x12f)]=TSR[_0x5d974d(0x1b5)][_0x5d974d(0x12f)],this['opacity']=TSR[_0x5d974d(0x1b5)][_0x5d974d(0x174)],this[_0x5d974d(0x189)]=TSR[_0x5d974d(0x1b5)][_0x5d974d(0x189)]);},Sprite_Reflect['prototype'][_0x155279(0x141)]=function(_0x2a5afa,_0x199082){const _0x39bf75=_0x155279,_0x53b0bd=_0x199082[_0x39bf75(0x183)](),_0x320f71=_0x53b0bd?_0x53b0bd[0x0]:null,_0xec6f29=_0x53b0bd?_0x53b0bd[0x1]:null;this[_0x39bf75(0x1c1)]=_0x53b0bd,this[_0x39bf75(0x14a)]=_0x2a5afa;const _0x110d9f=_0x199082['_floorMirrorOffset'];this[_0x39bf75(0x1b9)]=_0x199082[_0x39bf75(0x1e0)](),this[_0x39bf75(0x1d4)](this['_mirrorInfo']),this[_0x39bf75(0x15d)]=this[_0x39bf75(0x1ec)]*0x5a*Math['PI']/0xb4,this[_0x39bf75(0x158)]=new PIXI[(_0x39bf75(0x18a))][(_0x39bf75(0x145))](),this[_0x39bf75(0x158)][_0x39bf75(0x1ae)]=this[_0x39bf75(0x12f)],this[_0x39bf75(0x18a)]=[this[_0x39bf75(0x158)]];_0x110d9f&&(this[_0x39bf75(0x1ab)]=_0x110d9f[0x0],this[_0x39bf75(0x17f)]=_0x110d9f[0x1]);_0x199082['_scale']&&(this['scale']['x']=_0x199082[_0x39bf75(0x15f)],this['scale']['y']=_0x199082['_scale'],this['_offsetX']*=_0x199082[_0x39bf75(0x15f)],this[_0x39bf75(0x17f)]*=_0x199082[_0x39bf75(0x15f)]);this[_0x39bf75(0x1c2)]=this[_0x39bf75(0x142)]['x'],this['_originalScaleY']=this['scale']['y'],this[_0x39bf75(0x157)]=_0x199082,this['_characterName']=_0x320f71||_0x199082[_0x39bf75(0x18e)],this[_0x39bf75(0x1bc)]=_0xec6f29||_0x199082[_0x39bf75(0x1bc)];const _0x212580=ImageManager[_0x39bf75(0x1c6)](this[_0x39bf75(0x18e)]);this['_patternW']=_0x212580?0x3:0xc,this[_0x39bf75(0x1f1)]=_0x212580?0x4:0x8,_0x199082[_0x39bf75(0x1f6)]>0x0?(this[_0x39bf75(0x1f6)]=_0x199082[_0x39bf75(0x1f6)],this['bitmap']=this[_0x39bf75(0x13d)](this[_0x39bf75(0x1f6)]),this[_0x39bf75(0x170)]()):(this[_0x39bf75(0x1ef)]=ImageManager[_0x39bf75(0x18c)](this['_characterName']),this[_0x39bf75(0x12c)]()),this[_0x39bf75(0x179)]=0x0,this[_0x39bf75(0x1d3)]();},Sprite_Reflect[_0x155279(0x182)][_0x155279(0x1af)]=function(){const _0x14a104=_0x155279;Sprite[_0x14a104(0x182)][_0x14a104(0x1af)][_0x14a104(0x14c)](this);this[_0x14a104(0x157)][_0x14a104(0x160)]()>0x0?this['updateTileFrame']():this[_0x14a104(0x12c)]();this[_0x14a104(0x1d3)]();if(this[_0x14a104(0x189)])this[_0x14a104(0x1a5)]();this['visible']=!this[_0x14a104(0x157)]['isTransparent']()&&this[_0x14a104(0x19c)]();},Sprite_Reflect[_0x155279(0x182)][_0x155279(0x13d)]=function(_0x4bb5ab){const _0x5c5630=_0x155279,_0xf042eb=$gameMap[_0x5c5630(0x161)](),_0x3a6535=0x5+Math[_0x5c5630(0x131)](_0x4bb5ab/0x100);return ImageManager[_0x5c5630(0x166)](_0xf042eb[_0x5c5630(0x1e7)][_0x3a6535]);},Sprite_Reflect[_0x155279(0x182)]['updateTileFrame']=function(){const _0x3f6703=_0x155279,_0x13b4e5=this[_0x3f6703(0x1f6)],_0x102d39=$gameMap['tileWidth'](),_0x113e97=$gameMap[_0x3f6703(0x197)](),_0x39a137=(Math[_0x3f6703(0x131)](_0x13b4e5/0x80)%0x2*0x8+_0x13b4e5%0x8)*_0x102d39,_0xba2347=Math['floor'](_0x13b4e5%0x100/0x8)%0x10*_0x113e97;this[_0x3f6703(0x1df)](_0x39a137,_0xba2347,_0x102d39,_0x113e97);},Sprite_Reflect[_0x155279(0x182)]['updateCharacterFrame']=function(){const _0x2423bc=_0x155279,_0x377cf4=this[_0x2423bc(0x1bc)];let _0x148fb8=this[_0x2423bc(0x157)][_0x2423bc(0x1d0)]();!this[_0x2423bc(0x157)]['_isPickable']&&(this['_angle']<=0x1&&this[_0x2423bc(0x1ec)]>=-0x1?_0x148fb8=_0x148fb8===0x2||_0x148fb8===0x8?0xa-_0x148fb8:_0x148fb8:_0x148fb8=_0x148fb8===0x4||_0x148fb8===0x6?0xa-_0x148fb8:_0x148fb8);const _0x39c57e=this[_0x2423bc(0x1ef)][_0x2423bc(0x1f7)]/this[_0x2423bc(0x1b6)],_0x2c8b36=this[_0x2423bc(0x1ef)]['height']/this['_patternH'],_0xe7fb9e=(_0x377cf4%0x4*0x3+this['_character'][_0x2423bc(0x13a)]())*_0x39c57e,_0x5ecc5b=(Math[_0x2423bc(0x131)](_0x377cf4/0x4)*0x4+(_0x148fb8-0x2)/0x2)*_0x2c8b36;this['setFrame'](_0xe7fb9e,_0x5ecc5b,_0x39c57e,_0x2c8b36);},Sprite_Reflect['prototype']['updateCharacterMove']=function(){const _0xafef76=_0x155279;if(Imported[_0xafef76(0x1c4)]){this[_0xafef76(0x167)](this[_0xafef76(0x157)][_0xafef76(0x1ba)]);if(this[_0xafef76(0x157)][_0xafef76(0x19b)]()||this[_0xafef76(0x157)]['pullDist']()||this[_0xafef76(0x157)]['backDist']()){this['x']=this[_0xafef76(0x14a)]['x']+this['_offsetX'],this['y']=this[_0xafef76(0x14a)]['y']+this[_0xafef76(0x17f)];;}else this['x']=this[_0xafef76(0x157)][_0xafef76(0x148)]()+this[_0xafef76(0x1ab)],this['y']=this[_0xafef76(0x157)]['screenY']()+this[_0xafef76(0x17f)];}else this['x']=this[_0xafef76(0x157)][_0xafef76(0x148)]()+this[_0xafef76(0x1ab)],this['y']=this[_0xafef76(0x157)][_0xafef76(0x13f)]()+this[_0xafef76(0x17f)];},Sprite_Reflect[_0x155279(0x182)][_0x155279(0x167)]=function(_0x3f220e){const _0x5719f1=_0x155279,_0x73af8a=$gamePlayer;if(_0x73af8a['isHolding'](_0x3f220e)){let _0x2285af;this[_0x5719f1(0x1ec)]<=0x1&&this['_angle']>=-0x1?_0x2285af=0x8:_0x2285af=0x2,_0x73af8a[_0x5719f1(0x1d0)]()===_0x2285af?this['z']=-0.5:this['z']=-0.7;}},Sprite_Reflect['prototype'][_0x155279(0x1a5)]=function(){const _0x2bdaa7=_0x155279;this[_0x2bdaa7(0x179)]++,!this['_grow']?this[_0x2bdaa7(0x142)]['x']<this[_0x2bdaa7(0x1c2)]*1.05?(this[_0x2bdaa7(0x142)]['x']+=0.005,this[_0x2bdaa7(0x142)]['y']-=0.002):this['_grow']=!![]:this[_0x2bdaa7(0x142)]['x']>this['_originalScaleX']*0.95?(this['scale']['x']-=0.005,this[_0x2bdaa7(0x142)]['y']+=0.002):this[_0x2bdaa7(0x19e)]=![];},Sprite_Reflect[_0x155279(0x182)]['hasBitmap']=function(){const _0x48e140=_0x155279,_0x2218ef=this[_0x48e140(0x157)][_0x48e140(0x183)]()?this['_characterName']===this[_0x48e140(0x157)][_0x48e140(0x183)]()[0x0]:this[_0x48e140(0x18e)]===this['_character'][_0x48e140(0x1ad)](),_0x462593=this[_0x48e140(0x157)][_0x48e140(0x183)]()?this[_0x48e140(0x1bc)]===this[_0x48e140(0x157)]['reflectionChar']()[0x1]:this[_0x48e140(0x1bc)]===this[_0x48e140(0x157)][_0x48e140(0x1f8)]();return _0x2218ef&&_0x462593||(this['_tilesetId']===$gameMap['tilesetId']()||this[_0x48e140(0x1f6)]===this[_0x48e140(0x157)][_0x48e140(0x160)]());},Sprite_Reflect[_0x155279(0x182)][_0x155279(0x173)]=function(){const _0x201224=_0x155279;return this[_0x201224(0x157)][_0x201224(0x12d)](this[_0x201224(0x157)]['x'],this[_0x201224(0x157)]['y'])&&this[_0x201224(0x1b9)][0x0]===this[_0x201224(0x157)][_0x201224(0x1e0)]()[0x0]&&this[_0x201224(0x19c)]();};
})();

//==== END ======================================================================
//===============================================================================
